/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.handlers;

import com.ibm.hwmca.base.rsf.handlers.BaseRsfHandlersErrorIds;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ZPapCommandParser
extends DefaultHandler
implements BaseRsfHandlersErrorIds {
    private static final String TRACE_MASKD = "XSSIQS D";
    private static final String TRACE_MASKF = "XSSIQS F";
    private static FrameworkClassLogInfo logInfo;
    private static FrameworkLogAttributes infoLog;
    private static final boolean localDebug = false;
    private String xml;
    private String command = null;
    private HashMap attributes = new HashMap();
    private String attributeName;
    private String data;
    private ArrayList fixFileList = null;
    private static String input;
    private static final String fpListTag = "FIXPACKS";
    private static final String fixpackTag = "FP";
    private static final int ROOT_STATE = 0;
    private static final int START_STATE = 1;
    private static final int COMMAND_STATE = 2;
    private static final int END_COMMAND_STATE = 3;
    private static final int LIST_STATE = 4;
    private static final int ATTRIBUTE_NAME_STATE = 5;
    private static final int END_ATTRIBUTE_NAME_STATE = 6;
    private static final int ATTRIBUTE_VALUE_STATE = 7;
    private static final int END_ATTRIBUTE_LIST_STATE = 8;
    private static final int FP_LIST_STATE = 9;
    private static final int END_FP_LIST_STATE = 10;
    private static final int FP_STATE = 11;
    private static final int NUMBER_OF_STATES = 12;
    private static final String[] stateNames;
    private static final HashMap[] fsm;
    private int state = 0;

    public static void main(String[] argv) {
        String data = argv.length <= 0 ? input : argv[0];
        ZPapCommandParser parser = new ZPapCommandParser(data);
        Trace.trace(TRACE_MASKD, parser.getCommand().toString());
        Trace.trace(TRACE_MASKF, parser.getAttributes().toString());
    }

    public ZPapCommandParser(String xmlString) {
        Trace.trace(TRACE_MASKD, "-> ZPapCommandParser(): " + xmlString);
        this.xml = xmlString;
        String convertedString = "<root>" + xmlString + "</root>";
        try {
            SAXParser saxParser = new SAXParser();
            saxParser.setContentHandler((ContentHandler)this);
            saxParser.parse(new InputSource(new ByteArrayInputStream(convertedString.getBytes())));
        }
        catch (Throwable t) {
            Trace.trace(TRACE_MASKF, "ZPapCommandParser: Error parsing data: " + t.getMessage());
        }
    }

    public String getCommand() {
        return this.command;
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public ArrayList getFixFiles() {
        Trace.trace(TRACE_MASKD, "<> ZPapCommandParser::getFixFiles()");
        return this.fixFileList;
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.data = new String(buf, offset, len);
    }

    public void startElement(String namespaceURI, String sname, String qname, Attributes attrs) throws SAXException {
        Integer nextState;
        this.data = "";
        String name = sname;
        if (name.equals("")) {
            name = qname;
        }
        if (attrs != null) {
            // empty if block
        }
        if ((nextState = (Integer)fsm[this.state].get(name)) == null) {
            Trace.trace(TRACE_MASKF, "Parser: Input <" + name + "> not valid in state " + this.state + ":" + stateNames[this.state]);
            HException e = new HException("Retain xml parsing error");
            new FrameworkLog(logInfo, 28529, e).log(infoLog);
        } else {
            this.state = nextState;
        }
        if (this.state == 9 && this.fixFileList == null) {
            this.fixFileList = new ArrayList();
        }
    }

    public void endElement(String namespaceURI, String sname, String qname) throws SAXException {
        Integer nextState;
        switch (this.state) {
            case 2: {
                this.addCommand(this.data);
                break;
            }
            case 5: {
                this.addAttributeName(this.data);
                break;
            }
            case 7: {
                this.addAttributeValue(this.data);
                break;
            }
            case 11: {
                this.addFixFile(this.data);
                break;
            }
        }
        String name = sname;
        if (name.equals("")) {
            name = qname;
        }
        if ((nextState = (Integer)fsm[this.state].get(name = "/" + name)) == null) {
            Trace.trace(TRACE_MASKF, "Parser: Input <" + name + "> not valid in state " + this.state + ":" + stateNames[this.state]);
            HException e = new HException("Retain xml parsing error");
            new FrameworkLog(logInfo, 28529, e).log(infoLog);
        } else {
            this.state = nextState;
        }
    }

    private void addCommand(String data) {
        this.command = data;
    }

    private void addFixFile(String data) {
        Trace.trace(TRACE_MASKD, "Parser:addFixFile: " + data);
        this.fixFileList.add(data);
        Trace.trace(TRACE_MASKD, "Parser:fixFileList:" + this.fixFileList);
    }

    private void addAttributeName(String data) {
        this.attributeName = data;
    }

    private void addAttributeValue(String data) {
        this.attributes.put(this.attributeName, data);
    }

    static {
        HashMap<String, Integer> temp;
        logInfo = new FrameworkClassLogInfo(-44, "ZPapCmdParse");
        infoLog = FrameworkLogAttributes.INFO_LOG;
        input = "<cid>WritePhoneList</cid>\n<al><an>filename</an><av>ACTZCRY.TRM</av><an>filesize</an><av>12048</av><an>bs</an><av>4096</av></al>";
        stateNames = new String[]{"Root", "Start", "Command", "End Command", "List", "Attribute Name", "End Attribute Name", "Attribute Value", "End_Attribute_List", "Fixpack list", "End fixpack list", "Fixpack filename"};
        fsm = new HashMap[12];
        ZPapCommandParser.fsm[0] = temp = new HashMap<String, Integer>();
        temp.put("root", new Integer(1));
        temp = new HashMap();
        ZPapCommandParser.fsm[1] = temp;
        temp.put("cid", new Integer(2));
        temp.put("CID", new Integer(2));
        temp = new HashMap();
        ZPapCommandParser.fsm[2] = temp;
        temp.put("/cid", new Integer(3));
        temp.put("/CID", new Integer(3));
        temp = new HashMap();
        ZPapCommandParser.fsm[3] = temp;
        temp.put("/root", new Integer(0));
        temp.put("al", new Integer(4));
        temp.put("AL", new Integer(4));
        temp.put(fpListTag, new Integer(9));
        temp = new HashMap();
        ZPapCommandParser.fsm[4] = temp;
        temp.put("/al", new Integer(8));
        temp.put("/AL", new Integer(8));
        temp.put("an", new Integer(5));
        temp.put("AN", new Integer(5));
        temp = new HashMap();
        ZPapCommandParser.fsm[5] = temp;
        temp.put("/an", new Integer(6));
        temp.put("/AN", new Integer(6));
        temp = new HashMap();
        ZPapCommandParser.fsm[6] = temp;
        temp.put("av", new Integer(7));
        temp.put("AV", new Integer(7));
        temp = new HashMap();
        ZPapCommandParser.fsm[7] = temp;
        temp.put("/av", new Integer(4));
        temp.put("/AV", new Integer(4));
        temp = new HashMap();
        ZPapCommandParser.fsm[8] = temp;
        temp.put("/root", new Integer(1));
        temp = new HashMap();
        ZPapCommandParser.fsm[9] = temp;
        temp.put("/FIXPACKS", new Integer(10));
        temp.put(fixpackTag, new Integer(11));
        temp = new HashMap();
        ZPapCommandParser.fsm[10] = temp;
        temp.put("/root", new Integer(0));
        temp.put("al", new Integer(4));
        temp.put("AL", new Integer(4));
        temp = new HashMap();
        ZPapCommandParser.fsm[11] = temp;
        temp.put("/FP", new Integer(9));
    }
}

